---
type: glossary
tags:
  - "#layer/information"
  - "#status/stable"
  - "#function/observation"
---

# Cascade (pattern)

> Percolation/chain reaction through the network; local failure or ignition propagates widely.

---

## Definition

- Chain reaction through network
- Local triggers spread globally
- Amplification along paths
- Threshold-dependent spread

---

## Dual‑register mapping

### Technical (network/computational)

| Diagnostic concept | Network construct | Test example |
|-------------------|------------------|--------------|
| Chain reaction | Spread pattern | `Monitor`, `Spread` |
| Amplification | Growth rate | `Check`, `Rate` |
| Threshold | Trigger level | `Test`, `Level` |

### Humane (biological/relational)

| Diagnostic concept | Humane construct | Example |
|-------------------|------------------|----------|
| Chain reaction | Ripple effect | "Spreads out" |
| Amplification | Growing impact | "Gets bigger" |
| Threshold | Tipping point | "Tips over" |

### Crosswalk (bridge)

| Technical term | Humane term | Ontological meaning |
|---------------|-------------|-------------------|
| Spread pattern | Ripple effect | How change moves |
| Growth rate | Growing impact | How effects build |
| Trigger level | Tipping point | How change starts |

### Domain Examples

| Domain | Technical test | Humane test |
|--------|---------------|-------------|
| Physics | Phase change | Energy spread |
| Networks | Viral spread | Message wave |
| Cognition | Idea spread | Thought wave |
| Systems | State cascade | Change wave |

---

## Scale Effects

How Cascade pattern manifests differently at various scales:

### Micro Scale (ε-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ε | Trigger quantum | Wave spread |
| λV | Gate cascade | State wave |

### Human Scale (ψA-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| ψA | Phase spread | Memory wave |
| ∇S | Pattern growth | Clear spread |

### Cosmic Scale (c-bounded)

| Constant | Effect | Example |
|----------|--------|---------|
| c | Spread limit | Light wave |
| λV | Field cascade | Space wave |

Note: At extreme scales, cascade behavior faces fundamental limits (e.g., quantum percolation at ε, causal waves at c).

---

## Invariants / Thresholds

Scale-dependent bounds:
- ε: trigger threshold met
- c: spread within limits
- ψA: phase coherent
- λV: gates controlled

---

## SVA Coupling

Scale-dependent modulator effects:

| Scale | Modulator | Technical effect | Humane effect |
|-------|-----------|-----------------|---------------|
| Micro | ∇S | Spread pattern | Wave clarity |
| Human | λV | Gate cascade | Flow control |
| Cosmic | ψA | Phase spread | Wave binding |

---

## Failure Modes

Scale-dependent failure patterns:

| Scale | Mode | Technical signature | Humane signature |
|-------|------|-------------------|------------------|
| Micro | Over-spread | Pattern loss | Lost control |
| Human | Runaway | Unstable growth | Out of hand |
| Cosmic | Wave break | Structure loss | Lost binding |

---

## Diagnostic Checklist

Technical tests:
- [ ] Triggers localized
- [ ] Growth controlled
- [ ] Thresholds tuned
- [ ] Spread monitored

Humane tests:
- [ ] Change contained
- [ ] Impact managed
- [ ] Control points set
- [ ] Pattern tracked

---

## Design rationale

This diagnostic must maintain dual-register intelligibility per governance (see [PRINCIPLES.md](../../../../PRINCIPLES.md)). Neither technical percolation nor experiential spread alone captures its full meaning.

---

## See Also

- [[Path (chain) (pattern)]]
- [[Multi-path (redundant) (pattern)]]
- [[Bridge / Articulation (pattern)]]
- [[Form]]
- [[Field]]

---

## Dual‑register checklist

- [x] Technical mapping provided
- [x] Humane mapping provided
- [x] Crosswalk table included
- [x] Scale-aware tests documented